// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003-2007 - Steve Merrony 

// This program is free software; you may redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.

// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.

// You should have received a copy of the GNU General Public License along with 
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple 
// Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef MIDITHREAD_H
#define MIDITHREAD_H

#include <pthread.h>

#include <qapplication.h>
#include <qwaitcondition.h>

#include "application.h"
#include "console.h"

//class QWaitCondition;

 
class MidiThread {
  //  Q_OBJECT

  const char* name;

  pthread_t thread;


 public:

  MidiThread( volatile Console * );
  ~MidiThread();
  void start();
  void stop(bool);
  void run();
  
 private:
  volatile Console *sconsole;
  
  void connectDefaultPorts( midi_seq *, midi_port *, midi_port *, midi_port *, Console *);
};

#endif
