#!/usr/bin/python
#
# This file is part of Python Terra
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import evas
import ecore
import ecore.evas
import terra.ui.grid
import terra.ui.scrollbar

ee = ecore.evas.SoftwareX11(w=300, h=300)

canvas = ee.evas

bg = canvas.Rectangle(color=(0, 0, 0, 255))
bg.size = canvas.size
bg.show()
ee.data["bg"] = bg

colors = (
    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),

    (128, 0, 0, 255),
    (0, 128, 0, 255),
    (0, 0, 128, 255),
    (128, 255, 0, 255),
    (0, 128, 255, 255),
    (255, 0, 128, 255),

    (255, 128, 0, 255),
    (0, 255, 128, 255),
    (128, 0, 255, 255),

    (255, 0, 0, 255),
    (0, 255, 0, 255),
    (0, 0, 255, 255),
    (255, 255, 0, 255),
    (0, 255, 255, 255),
    (255, 0, 255, 255),

    (128, 0, 0, 255),
    (0, 128, 0, 255),
    (0, 0, 128, 255),
    (128, 255, 0, 255),
    (0, 128, 255, 255),
    (255, 0, 128, 255),

    (255, 128, 0, 255),
    (0, 255, 128, 255),
    (128, 0, 255, 255),
    )


class CellRenderer(evas.ClippedSmartObject, terra.ui.grid.CellRenderer):
    def __init__(self, canvas):
        evas.ClippedSmartObject.__init__(self, canvas)
        self.f = self.Rectangle()
        self.f.show()
        self.s = self.Rectangle(color=(255, 255, 255, 255))
        self.r = self.Rectangle(pos=(1, 1))
        self.r.show()
        self.t = self.Text(font=("Sans", 12))
        self.t.show()

    def resize(self, w, h):
        self.r.resize(w - 2, h - 2)
        self.f.resize(w, h)
        self.s.resize(w, h)
        self.s.center_set(*self.s.center_get())
        self.t.center_set(*self.s.center_get())

    def value_set(self, value):
        i, color = value
        self.r.color_set(*color)
        cr = color[0] ^ 255
        cg = color[1] ^ 255
        cb = color[2] ^ 255
        self.t.color_set(cr, cg, cb, 255)
        self.t.text_set(str(i))

    def selected_set(self, set):
        if set:
            self.s.show()
        else:
            self.s.hide()


x = y = 25
w, h = (v - 50 for v in canvas.size)
area = canvas.Rectangle(color=(128, 128, 128, 128), geometry=(x, y, w, h))
area.show()
ee.data["area"] = area

grid = terra.ui.grid.KineticGrid(canvas, CellRenderer, tuple(enumerate(colors)),
                                 renderer_size=(60, 60))
grid.geometry = (x, y, w, h)
grid.show()
grid.event_area.size = (w, h)
ee.data["grid"] = grid

def on_clicked(grid, idx):
    print grid, idx
grid.clicked_cb = on_clicked

knob = canvas.Rectangle(color=(200, 200, 200, 200))
knob.show()

sb = terra.ui.scrollbar.Scrollbar(canvas, knob)
sb.show()
ee.data["sb"] = sb


def position_changed_cb(grid, percent):
    sb.value_set(percent)
grid.position_changed_cb_set(position_changed_cb)


def on_resize(ee):
    canvas = ee.evas
    ee.data["bg"].size = canvas.size

    grid = ee.data["grid"]
    w, h = canvas.size
    grid.geometry_set(25, 25, w - 50, h - 50)

    area = ee.data["area"]
    area.geometry_set(25, 25, w - 50, h - 50)

    sb = ee.data["sb"]
    sb.resize(20, canvas.size[1])
    sb.top_right_set(canvas.size[0], 0)
    sb.scale_set(grid.visible_cols_scale_get())
ee.callback_resize = on_resize
on_resize(ee) # to enforce sb recalc


def on_key_down(obj, event):
    grid = ee.data["grid"]
    if event.keyname == "Escape":
        ecore.main_loop_quit()
    elif event.keyname == "0":
        grid.position_set(0.0)
    elif event.keyname == "1":
        grid.position_set(1.0)
    elif event.keyname == "5":
        grid.position_set(0.5)
    elif event.keyname == "Down":
        p = grid.position_get() + 0.01
        grid.position_set(p)
    elif event.keyname == "Up":
        p = grid.position_get() - 0.01
        grid.position_set(p)
bg.focus = True
bg.on_key_down_add(on_key_down)

ee.show()
ecore.main_loop_begin()
