/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;

public class BarGraph
extends Display {
    private boolean needScanData = true;
    private boolean useUserSuppliedValues = false;

    public BarGraph(DoctorPanel doctorPanel) {
        super(doctorPanel);
        if (this.ymax != 0.0 && this.yticks != 0) {
            this.useUserSuppliedValues = true;
        }
    }

    public void readData(Vector vector) {
        super.readData(vector);
        this.scanData();
        this.valid = false;
    }

    public void scanData() {
        int n;
        int n2;
        Graphics graphics = this.doctor.getGraphics();
        if (graphics == null) {
            return;
        }
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n3 = this.fontMetric.getHeight();
        int n4 = 0;
        while (n4 < this.nrows) {
            n2 = 0;
            while (n2 < this.ncols) {
                Data data = this.dataAt(n4, n2);
                double d = this.doubleValue(0.0, data.value);
                if (d > this.ymax) {
                    this.ymax = d;
                }
                ++n2;
            }
            ++n4;
        }
        this.calcYValues();
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= this.yticks) {
            n = (int)(this.ymin + (this.ymax - this.ymin) * (double)n6 / (double)this.yticks);
            String string = Integer.toString(n);
            if (this.ylabel != null) {
                string = String.valueOf(string) + this.ylabel;
            }
            if ((n2 = this.fontMetric.stringWidth(string)) > n5) {
                n5 = n2;
            }
            ++n6;
        }
        this.in.width = this.out.width - 2 * n5;
        this.in.x = 3 * n5 / 2;
        n = 0;
        int n7 = 0;
        while (n7 < this.ncols) {
            Data data = this.dataAt(-1, n7);
            String string = data.value;
            if (this.xlabel != null) {
                string = String.valueOf(string) + this.xlabel;
            }
            n += this.fontMetric.stringWidth(string);
            ++n7;
        }
        int n8 = (this.in.width - n) / this.ncols;
        int n9 = 0;
        while (n9 < this.ncols) {
            Data data = this.dataAt(-1, n9);
            String string = data.value;
            if (this.xlabel != null) {
                string = String.valueOf(string) + this.xlabel;
            }
            int n10 = this.fontMetric.stringWidth(string) + n8;
            data.setSize(n10, n3);
            ++n9;
        }
        this.fontMetric = graphics.getFontMetrics(this.titlefont);
        int n11 = 3 * this.fontMetric.getHeight() / 2;
        this.in.height = this.out.height - (n11 + 2 * n3);
        this.in.y = n11;
        if (this.firsttime) {
            this.scroller.setFirstTime();
        }
        this.firsttime = false;
    }

    public void drawHorizontalAxis(Graphics graphics) {
        int n = this.in.x;
        int n2 = this.in.y;
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n3 = this.fontMetric.getHeight();
        graphics.setFont(this.font);
        int n4 = n;
        int n5 = 0;
        while (n5 < this.ncols) {
            Data data = this.dataAt(-1, n5);
            String string = data.value;
            if (this.xlabel != null) {
                string = String.valueOf(string) + this.xlabel;
            }
            int n6 = data.width;
            graphics.setColor(this.axiscolor);
            graphics.drawLine(n4 + n6 / 2, n2 + this.in.height, n4 + n6 / 2, n2 + this.in.height + 5);
            graphics.setColor(this.fontcolor);
            graphics.drawString(string, n4 + 10, n2 + this.in.height + n3 + 6);
            n4 += n6;
            ++n5;
        }
    }

    public void drawVerticalAxis(Graphics graphics) {
        int n = this.in.x;
        int n2 = this.in.y;
        this.fontMetric = graphics.getFontMetrics(this.font);
        int n3 = this.fontMetric.getHeight() / 2;
        int n4 = 0;
        while (n4 <= this.yticks) {
            int n5 = n2 + this.in.height - this.in.height * n4 / this.yticks;
            int n6 = (int)(this.ymin + (this.ymax - this.ymin) * (double)n4 / (double)this.yticks);
            String string = Integer.toString(n6);
            if (this.ylabel != null) {
                string = String.valueOf(string) + this.ylabel;
            }
            int n7 = this.fontMetric.stringWidth(string);
            graphics.setColor(this.fontcolor);
            graphics.drawString(string, n - n7 - 10, n5 + n3 - 2);
            if (n4 > 0 && n4 < this.yticks) {
                graphics.setColor(this.axiscolor);
                graphics.drawLine(n, n5, n - 5, n5);
            }
            if (n4 > 0) {
                graphics.setColor(this.gridcolor);
                graphics.drawLine(n + 1, n5, n + this.in.width - 1, n5);
            }
            ++n4;
        }
    }

    public void drawIt(Graphics graphics) {
        if (this.needScanData) {
            this.scanData();
            this.needScanData = false;
        }
        graphics.setColor(this.backgroundcolor);
        graphics.fillRect(0, 0, this.out.width, this.out.height);
        this.drawHorizontalAxis(graphics);
        this.drawVerticalAxis(graphics);
        int n = 10;
        int n2 = this.in.x;
        int n3 = this.in.y;
        int n4 = n2;
        int n5 = 0;
        while (n5 < this.ncols) {
            Data data = this.dataAt(-1, n5);
            int n6 = data.width;
            int n7 = n = 20;
            data = this.dataAt(0, n5);
            double d = this.doubleValue(0.0, data.value);
            int n8 = (int)((double)this.in.height * (d - this.ymin) / ((this.ymax - this.ymin) * (double)this.yfactor));
            int n9 = n4 + n6 / 2 - n / 2;
            int n10 = n3 + this.in.height - n8;
            if (n8 != 0) {
                graphics.setColor(Color.black);
                graphics.fillRect(n9 + 4, n10 + 4, n7, n8 + 4);
                graphics.setColor(this.fillcolor);
                graphics.fillRect(n9, n10, n7, n8);
                graphics.setColor(this.linecolor);
                graphics.drawRect(n9, n10, n7, n8);
            }
            n4 += n6;
            ++n5;
        }
        graphics.setColor(this.axiscolor);
        graphics.drawRect(this.in.x, this.in.y, this.in.width, this.in.height);
        this.drawTitle(graphics);
    }

    private void calcYValues() {
        int[] nArray = new int[]{1, 1000, 1000000};
        int[][] nArrayArray = new int[22][];
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[0] = nArray2;
        nArrayArray[1] = new int[]{10, 5};
        nArrayArray[2] = new int[]{20, 4};
        nArrayArray[3] = new int[]{25, 5};
        nArrayArray[4] = new int[]{30, 6};
        nArrayArray[5] = new int[]{40, 8};
        nArrayArray[6] = new int[]{40, 4};
        nArrayArray[7] = new int[]{50, 5};
        nArrayArray[8] = new int[]{80, 8};
        nArrayArray[9] = new int[]{80, 4};
        nArrayArray[10] = new int[]{100, 5};
        nArrayArray[11] = new int[]{100, 4};
        nArrayArray[12] = new int[]{125, 5};
        nArrayArray[13] = new int[]{200, 4};
        nArrayArray[14] = new int[]{250, 5};
        nArrayArray[15] = new int[]{300, 6};
        nArrayArray[16] = new int[]{400, 8};
        nArrayArray[17] = new int[]{400, 4};
        nArrayArray[18] = new int[]{500, 5};
        nArrayArray[19] = new int[]{800, 8};
        nArrayArray[20] = new int[]{800, 4};
        nArrayArray[21] = new int[]{1000, 4};
        int[][] nArrayArray2 = nArrayArray;
        if (this.useUserSuppliedValues) {
            return;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < nArray.length) {
            n2 = 0;
            while (n2 < nArrayArray2.length) {
                int n3 = nArrayArray2[n2][0] * nArray[n];
                if ((double)n3 >= this.ymax) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (!bl) {
            int n4 = 2;
            ++n4;
        }
        this.yticks = nArrayArray2[n2][1];
        this.yfactor = nArray[n];
        this.ymax = nArrayArray2[n2][0];
        if (this.yfactor == 1000) {
            this.ylabel = " k";
            return;
        }
        if (this.yfactor == 1000000) {
            this.ylabel = " M";
            return;
        }
        this.ylabel = "";
        this.ymax *= (double)this.yfactor;
        this.yfactor = 1;
    }
}

