# -*- Mode: Python; tab-width: 4 -*-

import ftp_server

# create a 'dummy' authorizer (one that lets everyone in) that returns
# a read-only filesystem rooted at '/homes/ftp'

authorizer = ftp_server.dummy_authorizer ('/homes/ftp')

# Create an ftp server using this authorizer, running on port 8021
# [the standard port is 21, but you are probably already running
#  a server there]

fs = ftp_server.FTP_SERVER (authorizer, port=8021)

# to test this server, try
# $ ftp myhost 8021
# when using the standard bsd ftp client,
# $ ncftp -p 8021 myhost
# when using ncftp, and
# ftp://myhost:8021/
# from a web browser.
