#
#      Copyright (C) 2005-2008 Team XBMC
#      http://www.xbmc.org
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

#Shoutcast .pls updater for XBMC. Use at your own risk!
#Edit CONFIG part in script, copy script to $HOME\script\ directory,
#start and enjoy.
#Keep in mind, that updating too frequently or with too many
#genres and/or stations will "bann" you from shoutcast for ~24h.
#Feel free to edit, bugfix, enhance and so on... :-)
#Initial version by NEI

# Known issues:
#  -None for the moment ;-)


####################### CONFIG ########################

#Directory where you want to store your radio stations
SHOUTCAST_DIR = 'f:\\Music\\Radio\\'

#Genres
GENRES = ['Downtempo', 'Hip Hop', 'Drum and Bass', 'Smooth', 'Ambient', 'R&B/Soul']

#Minimum bitrates for stations (0 -> All)
MIN_BITRATE = 128

#Maximum bitrate for stations (999 -> All)
MAX_BITRATE = 256

#(0 or 1) To enable or disable the bitrate in the filename
SHOW_BITRATE_IN_FILENAME = 1

#Number of stations to retrieve.
MAX_NUMBER_OF_STATIONS = 9

#######################################################


#DO NOT EDIT FROM HERE ON (If you don't know what you're doing, of course ;-)
import xbmc, xbmcgui
import urllib2, os, sys, traceback
from os import makedirs
from os.path import normpath,dirname,exists,abspath,join

XFS_FILE_LENGTH = 42

SHOUTCAST_GENRE_PATH = 'http://www.shoutcast.com/directory/?sgenre=%s&numresult=100'

#Chars accepted for filenames on XFS
LEGAL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890!#$%&'()-@[]^_`{}~."

#class for storing pls stuff.
class PlsDescriptor:
    #Converts the line with the filename.pls in an URL
    def __init__(self, fileLine, bitrate):
        startIndex = fileLine.find('/sbin')
        endIndex = fileLine.find('filename.pls') + 12
        self.fileURL = 'http://www.shoutcast.com' + strip(fileLine, startIndex, endIndex)
        self.bitrate = bitrate
    
    #Returns the URL to be used for getting the pls file content.
    def get_fileURL(self):
        return self.fileURL
        
    #Returns the bitrate for this PlsDescriptor.
    def get_bitrate(self):
        return self.bitrate


# Removes all chars at the end, that are loner than length.
# Stupid to implement this myself, but couldn't find an
# approriate function for it...
def strip(stringToStrip, startIndex, endIndex):
    if endIndex >= len(stringToStrip):
        endIndex = len(stringToStrip) - 1
    strippedString = ''
    i = startIndex
    while i <= endIndex:
        strippedString = strippedString + stringToStrip[i]
        i += 1
    return strippedString.rstrip() #remove newline character (and any ending whitespaces)


#Substitutes all illegal chars for XFS with ' '
def subst_illegal_chars(stringToCheck):
    for char in stringToCheck:
        if LEGAL_CHARS.find(char) == -1:
            stringToCheck = stringToCheck.replace(char, ' ')
    return stringToCheck


# Gets the filename out of the first title in the pls file.
# Removes the (#2 - 187/750) and strips it to ??? characters.
def get_filename(plsFileContent, bitrate):
    fileName = ''
    for line in plsFileContent:
        if line.startswith('Title1='):
            fileName = line
            break
    if fileName == '': #happens, if there were too many requests
        raise Exception('Too many requests, try again tomorrow...')
    splittedName = fileName.split(') ', 1)
    fileName = splittedName[1]
    if SHOW_BITRATE_IN_FILENAME == 1:
        # -4 -> ".pls", -3 -> i.e.: "19 ", -5 -> 999k -1 -> index
        fileName = strip(fileName, 0, XFS_FILE_LENGTH - 4 - 3 - 5 - 1) + ' %sk.pls' % bitrate
    else:
        # -4 -> ".pls", -3 -> i.e.: "19 ", -1 -> index
        fileName = strip(fileName, 0, XFS_FILE_LENGTH - 4 - 3 - 1) + '.pls'
    fileName = subst_illegal_chars(fileName)
    return fileName

#Converts non http chars to them.
#Enhance if necessary.
def get_genre_url(genre):
    genreURL = genre.replace(' ', '\%20')
    genreURL = genreURL.replace('&', '\%26')
    return genreURL


#creates missing directories for the given path
def make_path(path):
    dpath = normpath(dirname(path))
    if not exists(dpath): makedirs(dpath)
    return normpath(abspath(path))


# Saves the content under the given path. (i.e. f:\music\shoutcast\blabla.pls)
def save_file(dir, fileName, content):
    dir = make_path(dir)
    file = open(dir + '\\' + fileName, 'w')
    file.writelines(content)
    file.close


#Just strips the line at the right indices. Line will always look something like this:
#      <td nowrap align="center" bgcolor="#001E5A"><font face="Arial, Helvetica" size="2" color="#FFFFFF">128</font></td>
#Returns an int reprecenting the bitrate or -1, if conversion failed
def get_bitrate(bitrateLine):
    bitrateString = strip(bitrateLine, 105, len(bitrateLine) - 14)
    bitrate = -1
    try:
        bitrate = int(bitrateString)
    except:
        print "Parsing of bitrate failed: \n" + bitrateLine
    return bitrate


# Gets the stations out of the html page by looking for a 'filename.pls' string.
def get_stations(htmlContent):
    stations = []
    for line in htmlContent:
        if line.find('filename.pls') != -1:
            #always seven lines later its the html content with the bitrate
            bitrate = get_bitrate(htmlContent[htmlContent.index(line) + 7])
            if MIN_BITRATE <= bitrate <= MAX_BITRATE:
                stations.append(PlsDescriptor(line, bitrate))
            if len(stations) == MAX_NUMBER_OF_STATIONS:
                break
    return stations

#Delete directory
def clean_dir(dirname):
    for root, dirs, files in os.walk(dirname):
        for name in files:
            os.remove(join(root, name))

#dialog asking user if he wants to start the update
def start_update():
    dialog = xbmcgui.Dialog()
    title = "Shoutcast update"
    question =  "Do you want to update %s?" % SHOUTCAST_DIR
    config1 = "Number of stations/genre: %s, Bitrate: %sk - %sk" % (MAX_NUMBER_OF_STATIONS, MIN_BITRATE, MAX_BITRATE)
    if SHOW_BITRATE_IN_FILENAME == 1:
        config2 = "Show bitrate in filename: yes"
    else:
        config2 = "Show bitrate in filename: no"
    selected = dialog.yesno(title, question, config1, config2)
    return selected

##### main() #####
if start_update():
    try:
        dialog = xbmcgui.DialogProgress()
        genreIndex = 1
        for genre in GENRES:
            genreStatus = 'Updating ' + genre + ' (%s/%s)' % (genreIndex, len(GENRES))
            dialog.create('Shoutcast update', genreStatus + "\nGetting station list...")
            clean_dir(SHOUTCAST_DIR + subst_illegal_chars(genre))
            genrePage = urllib2.urlopen(SHOUTCAST_GENRE_PATH % get_genre_url(genre))
            stations = get_stations(genrePage.readlines())
            genrePage.close()
            dialog.close()
            dialog.create('Shoutcast update', genreStatus + "\nProcessing stations...")
            numberOfStations = len(stations)
            stationIndex = 1
            for station in stations:
                if dialog.iscanceled():
                    break
                dialog.update((stationIndex * 100)/ numberOfStations)
                plsFile = urllib2.urlopen(station.get_fileURL())
                plsFileContent = plsFile.readlines()
                plsFile.close()
                directory = SHOUTCAST_DIR + subst_illegal_chars(genre) + '\\'
                fileName = '%s ' + get_filename(plsFileContent, station.get_bitrate())
                save_file(directory, fileName % stationIndex, plsFileContent)
                stationIndex += 1
            if dialog.iscanceled():
                break
            dialog.close()
            genreIndex += 1
        if dialog.iscanceled():
            dialog.close()
    except:
        dialog.close()
        dialog = xbmcgui.Dialog()
        traceback.print_exc()
        dialog.ok("Unexpected Error", "%s\nPress white button after closing the dialog for more info." % sys.exc_info()[0])
        
