#
#      Copyright (C) 2005-2008 Team XBMC
#      http://www.xbmc.org
#
#  This Program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This Program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with XBMC; see the file COPYING.  If not, write to
#  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#  http://www.gnu.org/copyleft/gpl.html
#

Enter = '\n'

print "***IMDbLib.py Example Script***"
print "===============================" + Enter * 3




print "How to import IMDbLib.py into your script:"
print "------------------------------------------" + Enter

print "(1)   import IMDbLib"
print "(2)   from IMDbLib import IMDb, IMDbSearch, IMDbGallery" + Enter
print "If you chose to use import method (1), you must reference the library's"
print 'name before using the class, for example:' + Enter
print 'IMDbLib.IMDb(url)' + Enter
print 'otherwise, to use import method (2), just simply use:' + Enter
print 'IMDb(url)' + Enter * 2


print "{IMDb Class} Selecting Your Movie With An IMDb URL:"
print "---------------------------------------------------" + Enter

print '(1)   Movie = IMDbLib.IMDb("http://www.imdb.com/title/tt0265666/")'
print '(2)   Movie = IMDb("http://www.imdb.com/title/tt0265666/")' + Enter

print "You MUST reference the IMDb class, with a valid IMDb url, to use this library."
print "This will retrieve all available information from the url you provided."
print "IMDb URLs come in a few different formats, for example:"
print '"http://www.imdb.com" & "http://us.imdb.com"'
print "Both the URL types above are valid since both sites have the same page format." + Enter * 2


print "Retrieving Parsed IMDb Information:"
print "-----------------------------------" + Enter *2

print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
print "Example 1 - How to retrieve IMDb information:"
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + Enter

print "Usage:"
print "    print str(Movie.Title)" + Enter
print "Result:"
print "    The Royal Tenenbaums (2001)" + Enter
print 'You can replace "Title" in "Movie.Title" with any of the following words:' + Enter
print "Directors, Writers, Genres, Details, Year, Tagline, Plot, Rating, MPAA"
print "Runtime, Cast, Countries, Languages" + Enter * 2

print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
print "Example 2 - How to re-format entries in a list:"
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + Enter

print "Usage:"
print "    for Writers in Movie.Writers:"
print "        print Writers" + Enter
print "Result:"
print "    Wes Anderson\n    Owen Wilson" + Enter * 2

print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
print "Example 3 - How to re-format keys in a dictionary:"
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + Enter

print "Usage:"
print "    Cast = Movie.Cast"
print "    for k in Cast.keys():"
print "        print '%-30.30s as %s'%(k,Cast[k])" + Enter
print "\nResult:"
print "    Grant Rosenmeyer               as Ari Tenenbaum"
print "    Irene Gorovaia                 as Young Margot Tenenbaum" + Enter * 2


print "Full List Of Available Functions:"
print "---------------------------------" + Enter

print "Title           (Movie Title, as a String)"
print "Directors       (Director(s), in a List)"
print "Writers         (Writer(s), in a List)"
print "Year            (Year, as a String)"
print "Genres          (Genre(s), in a List)"
print "Tagline         (Tagline, as a String)"
print "Plot            (Plot Outline, as a String)"
print "Rating          (Movie Rating, as a String)"
print "MPAA            (MPAA Rating, as a String)"
print "Runtime         (Film Length, in a List)"
print "Details         (Full Movie Details, as a String)"
print "Countries       (Countries, in a List)"
print "Languages       (Languages, in a List)"
print "Cast            (Actors and Characters, in a Dictionary)" + Enter * 2


print "________________________________________________________________________________" + Enter * 2


print "{IMDbSearch Class} Search IMDb Movie Titles"
print "-------------------------------------------" + Enter

print '(1)   Search = IMDbLib.IMDbSearch("your search string")'
print '(2)   Search = IMDbSearch("your search string")' + Enter

print 'This will save a dictionary of possible IMDb matches.'
print 'Search.keys()      This will retrieve the titles for the possible matches'
print 'Search.values()    This will retrieve the urls for the possible matches' + Enter * 2

print 'Retrieving Parsed Titles From IMDbSearch:'
print '-----------------------------------------' + Enter


print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
print "Example 1 - How to retrieve your search results:"
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" + Enter

print "Usage:"
print "    print IMDbSearch('space balls').SearchResults" + Enter
print "Result:"
print "    {'Call from Space (1989)': 'http://www.imdb.com/title/tt0097006/', 'The Space Between All Things (2006)': 'http://www.imdb.com/title/tt0456008/'" + Enter * 2


print "________________________________________________________________________________" + Enter * 2


print "{IMDbGallery Class} Gallery URLs For Movie Titles"
print "-------------------------------------------------" + Enter

print '(1)   Gallery = IMDbLib.IMDbGallery("your search string")'
print '(2)   Gallery = IMDbGallery("your search string")' + Enter

print "You MUST reference the IMDbGallery class with a valid IMDb Photo Gallery url to use this library."
print "This class will retrieve all three levels of a title's Photo Gallery." + Enter

print "There are three levels to the IMDbGallery class, they are as follows:"

print "Level 1:"
print "    - Gal1_info   (Dictionary, Gallery URLs (keys) : Gallery Thumbnail (values)"
print "    - Gal1_xy     (Dictionary, Thumbnail Width (keys) : Thumbnail Height (values)" + Enter

print "Level 2:"
print "    - Gal2_info   (Dictionary, Thumbnail URLs (keys) : Gallery Thumbnails (values)"
print "    - Gal2_xy     (Dictionary, Thumbnail Width (keys) : Thumbnail Height (values)" + Enter

print "Level 3:"
print "    - Gal3_info   (List, Big Thumbnail URLs)"
print "    - Gal3_xy     (Dictionary, Big Thumbnail Width (keys) : Big Thumbnail Height (values)" + Enter

print "**NOTE** Please open IMDbLib_Example.py in a text editor and read through the code to see"
print "an example of how to use the IMDbGallery Class, as well as how to blend all three Classes"
print "together to work as one script **NOTE**"
